using System;
using System.Collections;
using System.Net;

namespace gov.va.med.VBECS.VistaLinkServer.Core
{
	/// <summary>
	/// This class represents list of IP addresses that are 
	/// granted access for published procedure on server.
	/// 
	/// Encapsulates deserialization from XML config and 
	/// verification of access for supplied IP address. 
	/// </summary>
	public class PublishedProcedureIpAccessList
	{
		private readonly ArrayList _ipAccessList;

		/// <summary>
		/// Constructor accepting list of allowed IP addresses as <see cref="ArrayList"/>.
		/// May be used by derived classes for extendibility purposes. 
		/// </summary>
		/// <param name="ipAccessList">
		///		ArrayList containing list of allowed IP addresses 
		///		represented with <see cref="IPAddress"/> objects.
		///	</param>
		public PublishedProcedureIpAccessList( ArrayList ipAccessList )
		{
			if( ipAccessList == null )
				throw( new ArgumentNullException( "ipAccessList" ) );

			_ipAccessList = ipAccessList;
		}

		/// <summary>
		/// Verifies access for supplied IP address.
		/// </summary>
		/// <param name="clientIpToCheck">IP address to verify.</param>
		/// <returns>True if a given IP address is allowed. Otherwise - false.</returns>
		public bool IsIpAllowedAccess( IPAddress clientIpToCheck )
		{
			if( clientIpToCheck == null )
				throw( new ArgumentNullException( "clientIpToCheck" ) );

			return _ipAccessList.Contains( clientIpToCheck );
		}
	}
}
